<?php
require_once 'madeline.php';
use danog\MadelineProto\API;

$ref = $_SERVER['HTTP_REFERER'] ?? '';
$host = '';
if ($ref) {
    $do = parse_url($ref);
    $host = $do['host'] ?? '';
}

$short = $_GET['code'] ?? "";   

$seflink = "https://apkbuddy.in/";
$allowed  = 'apkbuddy.in'; 

// Compare normalized host
if ($host == $allowed) {

ignore_user_abort(true);
set_time_limit(0);

$MadelineProto = null; // global for shutdown function

// Shutdown function ensures MadelineProto always closes
register_shutdown_function(function() use (&$MadelineProto) {
    if (isset($MadelineProto)) {
        try {
            $MadelineProto->close();
        } catch (Throwable $e) {}
        $MadelineProto = null;
    }
    gc_collect_cycles();
});

if (!isset($_GET['id'])) {
    http_response_code(400);
    exit("❌ Missing message id");
}

$msg_id  = (int)$_GET['id'];
$channel = '-3600289727';

try {
    // --- Close any previous MadelineProto session first ---
    if (isset($MadelineProto)) {
        try {
            $MadelineProto->close();
        } catch (Throwable $e) {}
        $MadelineProto = null;
        gc_collect_cycles();
    }

    // --- Start a new MadelineProto session ---
    $MadelineProto = new API('session.madeline');
    $MadelineProto->start();

    // --- Fetch message ---
    $message = $MadelineProto->channels->getMessages([
        'channel' => $channel,
        'id'      => [$msg_id]
    ]);

    $media = $message['messages'][0]['media'] ?? null;
    $doc   = $media['document'] ?? $media['video'] ?? null;
    if (!$doc) {
        http_response_code(404);
        exit("❌ No media found");
    }

    // --- Get download info ---
    $info = $MadelineProto->getDownloadInfo($doc);
    $name = $info['name'] ?? 'video.mp4';
    $mime = $info['mime'] ?? 'video/mp4';

    if (!pathinfo($name, PATHINFO_EXTENSION)) {
        $extMap = [
            'application/vnd.android.package-archive' => 'apk',
            'video/mp4' => 'mp4',
            'video/x-matroska' => 'mkv',
            'audio/mpeg' => 'mp3',
            'application/zip' => 'zip',
            'image/jpeg' => 'jpg',
            'image/png' => 'png',
            'application/pdf' => 'pdf'
        ];
        $ext = $extMap[$mime] ?? '';
        if ($ext) $name .= '.' . $ext;
    }

    // --- Output headers ---
    header("Content-Type: $mime");
    header("Content-Disposition: inline; filename=\"" . basename($name) . "\"");
    header("Cache-Control: public, must-revalidate, max-age=0");

    // --- Stream to browser ---
    $MadelineProto->downloadToBrowser($doc);


} catch (Throwable $e) {
    http_response_code(500);
    echo "❌ Error: " . $e->getMessage();
}


exit;

} else {

    header("Location: {$seflink}{$short}");
    exit;
}
?>